---
Note type: Zettel
tags:
  - "#Zettel"
Related areas:
  - "[[Research]]"
Related projects:
  - "[[Paper X]]"
Related tasks: 
Related MoCs:
  - "[[Performativity MoC]]"
Related references:
  - "[[Kuhn, Ashcraft & Cooren 2017]]"
  - "[[Ashcraft, Kuhn & Cooren 2018]]"
  - "[[Taylor 2011]]"
  - "[[Taylor, Cooren, Giroux & Robichaud 1996]]"
  - "[[Robichaud, Giroux & Taylor 2004]]"
  - "[[Kuhn 2017]]"
  - "[[Scheneborg, Kuhn & Karreman 2019]]"
  - "[[Cooren 2010]]"
  - "[[Cooren 2012]]"
  - "[[Cooren 2004]]"
  - "[[Cooren 2009]]"
  - "[[Cooren & Martine 2016]]"
  - "[[Cooren et al 2011]]"
  - "[[Bencherki & Cooren 2011]]"
  - "[[Vasquez, Schoeneborn & Sergi 2016]]"
  - "[[Schoeneborn & Vasquez 2017]]"
  - "[[Cooren 2016]]"
  - "[[Scherer & Rasche 2016]]"
  - "[[Spee & Jarzabkowski 2011]]"
  - "[[Cooren 2020]]"
  - "[[Grothe-Hammer, Berkowitz & Berthod 2022]]"
  - "[[Smith 2022]]"
  - "[[Bencherki 2016]]"
Related zettels:
  - "[[text CCO]]"
  - "[[conversation CCO]]"
  - "[[political risk of reifying text]]"
  - "[[authoritative text]]"
  - "[[speech act theory]]"
  - "[[communication]]"
Related meeting notes: 
Related resources: 
Related people:
  - "[[François Cooren]]"
  - "[[James R. Taylor]]"
  - "[[Timothy Kuhn]]"
  - "[[Karen Ashcraft]]"
  - "[[Niklas Luhmann]]"
aliases:
  - CCO
  - Communicative Constitution of Organisation
  - Communication as Constitutive of Organization
  - Communication as Constitutive of Organizing
  - Communication as Constitutive of Organisation
  - Communication as Constitutive of Organising
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## Fleeting notes

## General notes

### Conceptual roots and connections

Intellectual precursors: [[John Dewey]], [[Chester Barnard]], [[Mary Parker Follett]], and [[Gabriel Tarde]]

#### Relationship with other schools of thought

- [[pragmatism]]
- [[Actor-Network Theory]]
- Rejects the [[transmission model of communication]]
	- [[performativity]]
	- [[social constructivism]]
	- [[interpretivism]]
- “some researchers have started to integrate a [[decisional OT|decision-based view of organization]] with the “Communication as Constitutive of Organization" (Brummans et al., 2014; Schoeneborn et al., 2014). In this regard, Dobusch and Schoeneborn 2015 developed the concept of degrees of organizationality, thereby partly drawing on sociological systems theory and partial organization theory. They introduced the idea that collectives can be seen as more or less organizational as long as they feature at least instances of interconnected decision-making.” ([[Grothe-Hammer et al. 2022]], p. 32)

### Definitions of the [[Communicative Constitution of Organization]]

[[Communicative Constitution of Organization]]: “In CCO perspectives, organizations are not contexts where communication takes place, but rather organizations are made manifest through communicative action and interaction (Cooren, 2010). This line of thinking differs from the “container metaphor” (Axley, 1984) that treats communication as one of many variables occurring within an established organization.” ([[Smith 2022]], p. 1818)

CCO holds that [[communication]] ‘is the means by which organizations are established, composed, designed, and sustained’ ([[Cooren et al 2011]])

CCO stresses that we cannot take the organization for granted:
- "the organization not as a pregiven and monolithic entity; instead, it reframes organizations as ongoing and interconnected communicative processes." [[Kuhn 2017]] p. 19)
- CCO "explains how the organization comes to be, i.e. emerges from interactions ([[Bencherki & Cooren 2011]] p. 1584)

#### Definitions of [[communication]]

- Communication is "the recursive articulation of conversations and texts (Taylor and Van Every, 2000)" ([[Vásquez, Schoeneborn & Sergi 2016]] p5. )
- "organization emerges in communication as described in text and realized in conversation. When described, organization becomes an object toward which organizational actors will co-orient their actions. When realized, organization is enacted through interaction and is related to processes of meaning negotiation." ([[Vásquez, Schoeneborn & Sergi 2016]] p. 5-6)
- communication is “the ongoing, dynamic, interactive process of manipulating symbols toward the creation, maintenance, destruction, and/or transformation of meanings, which are axial —not peripheral —to organizational existence and organizing phenomena” ([[Ashcraft et al. 2009]], p. 22)
- [[communication]] constitutes working and organizing by bringing together a multiplicity of agencies in the production of meanings that generate and sustain processes of coordination and control." ([[Kuhn, Ashcraft & Cooren 2017]]) p. 69)

The dialectic of [[conversation CCO|conversation]] and [[text CCO|text]] is concerned with the context of communication:
- CCO emphasizes "the contingent nature of communication, which implies that meaning is always situated in specific circumstances characterized by the ongoing oscillation between conversations and texts (Taylor and Van Every, 2000; Taylor et al., 1996). In that respect, people in interaction make sense of a particular utterance by relating it to the situation of language use" ([[Vásquez, Schoeneborn & Sergi 2016]] p. 6)

### 3 Schools of [[Communicative Constitution of Organization]]

#### McPhee & Zaug's Four Flows

- Based on [[Anthony Giddens|Giddens]]' [[structuration theory]]
- 4 types of message flows, according to McPhee & Zaug:
	 1. Membership negotiation
	 2. Self-structuring
	 3. Activity coordination
	 4. Institutional positioning

#### The Montréal School

 - [[James Taylor]]; [[Francois Cooren]] (e.g. [[Cooren 2012]]); [[Bruno Latour]]
 - Rooted in [[Actor-Network Theory|ANT]]; [[speech act theory]] ([[J.L. Austin|Austin]], [[John Searle|Searle]])
 - Key text - [[Taylor, Cooren, Giroux & Robichaud 1996]]
 - Two key translations (structuration):
	 - From text to conversation
	 - From conversation to text
 - Conversations are made of speech acts, are unpredictable
 - Texts are narrativised

#### Luhmannian [[social systems]]

 - Rooted in the social systems approach of [[Niklas Luhmann]]
 - Developed by Seidl, Schoeneborn, Blaschke
 - Separates communication from agents - the social system is made of communication rather than human beings - link to memetics
 - Organizational systems are specifically about decision communications

